import asyncio

from PyQt6.QtCore import QTimer

from api.client import async_client, profile
from core.WindowManager import WindowManager
from models.config.AppConfigModel import AppConfigModel
from utils.platform_helper import is_dev_mode


class AuthService:
    @staticmethod
    def auth():
        print('AuthService start auth')
        if AppConfigModel.load().session_id:
            QTimer.singleShot(0, lambda: asyncio.create_task(AuthService.check_profile_and_open_chat()))
        else:
            AuthService.force_logout_and_show_login()

    @staticmethod
    async def check_profile_and_open_chat():
        try:
            # Set session_id cookie to api async client
            async_client.cookies.set('session_id', AppConfigModel.load().session_id)
            await profile()
            # self.session_id = ConfigService.config.get('session_id')
            WindowManager.open_chat_window()
        except Exception as e:
            if is_dev_mode():
                print("=== TRACEBACK ===")
                import traceback
                print("".join(traceback.format_stack()))
                print("".join(traceback.format_exc()))
            else:
                print(e)
            if str(e) != 'Unauthorized: Authentication required':
                AuthService.force_logout_and_show_login()
            pass

    @staticmethod
    def force_logout_and_show_login():
        '''
        Always show or create only one login window at a time.
        This avoids duplicated login forms in the PyQt application.
        '''
        # app = QApplication.instance()
        # # Close all chat/settings windows
        # for w in app.topLevelWidgets():
        #     if w.__class__.__name__ in ('FormChat', 'FormAppSettings'):
        #         w.close()

        WindowManager.open_login_window()
