import os
from enum import Enum

from PyQt6.QtCore import QCoreApplication
from PyQt6.QtWidgets import QWidget, QApplication

# noinspection PyUnusedImports
import resources_rc
from utils import resource_path, log_info


class StyleMode(Enum):
    DARK = "dark"
    LIGHT = "light"

class StylesService:
    @staticmethod
    def loadStyle(name: str, mode: StyleMode) -> str:
        qss_path = resource_path(os.path.join("assets", "styles", f"{name}_{mode.value}.qss"))
        with open(qss_path, "r", encoding="utf-8") as f:
            qss = f.read()
            return qss

    @staticmethod
    def loadStyles(*names: str, mode: StyleMode) -> str:
        qss = ""
        for name in names:
            qss += StylesService.loadStyle(name, mode)
        return qss

    @staticmethod
    def setAppStyles(application: QApplication = None, mode: StyleMode = StyleMode.DARK) -> None:
        try:
            qss = StylesService.loadStyles("app", "components", mode=mode)
            if application is None:
                application = QCoreApplication.instance()
            application.setStyleSheet(qss)
        except Exception as e:
            log_info(f"[StylesService] Couldn't apply app core styles: {e}")

    @staticmethod
    def setWidgetStyle(widget: QWidget, name: str, mode: StyleMode = StyleMode.DARK) -> None:
        try:
            qss = StylesService.loadStyle(name, mode=mode)
            widget.setStyleSheet(qss)
        except Exception as e:
            log_info(f"[StylesService] Couldn't apply {name} style {mode} mode: {e}")
