import os
import sys

from PyQt6.QtWidgets import QApplication

from core.formChat.project_manager import ProjectManager
from core.settings_manager import SettingsManager
from models.config.AppConfigModel import AppConfigModel
from services.LanguageService import LanguageService
from services.StylesService import StylesService
from services.auth_sevice import AuthService
from utils.platform_helper import is_windows


class ApplicationService:
    @staticmethod
    def startup(app: QApplication):
        AppConfigModel.load()
        StylesService.setAppStyles(app)
        LanguageService.initService()
        SettingsManager.instance()
        AuthService.auth()

    @staticmethod
    def logout():
        ProjectManager.clear()
        AuthService.force_logout_and_show_login()

    @staticmethod
    def restart():
        if not is_windows():
            python = sys.executable
            os.execl(python, python, *sys.argv)

    @staticmethod
    def close():
        QApplication.instance().quit()