from core.config.ConfigLoader import ConfigLoader
from models.config.AppSettingsModel import AppSettingsModel


class SettingsManager:
    app_settings: AppSettingsModel | None
    __instance = None

    @staticmethod
    def instance():
        if SettingsManager.__instance is None:
            SettingsManager.__instance = SettingsManager()
            return SettingsManager.__instance
        return SettingsManager.__instance

    def __init__(self):
        self.__loader = ConfigLoader("app_settings.json", AppSettingsModel)
        self.app_settings = None
        self.load_settings()

    def load_settings(self):
        self.app_settings = self.__loader.load()

    def save_settings(self):
        self.__loader.save(self.app_settings, indent=4)
