from enum import Enum

from PyQt6.QtWidgets import QWidget, QVBoxLayout, QBoxLayout, QHBoxLayout


class ViewWrapperMode(Enum):
    Vertical = 0
    Horizontal = 1

class ViewWrapper:
    def __init__(self, parent: QWidget, mode: ViewWrapperMode):
        self.parent = parent
        if mode is ViewWrapperMode.Vertical:
            self.layout = QVBoxLayout(self.parent)
        else:
            self.layout = QHBoxLayout(self.parent)

    def add_widget(self, widget: QWidget) -> "ViewWrapper":
        self.layout.addWidget(widget)
        return self

    def add_stretch(self) -> "ViewWrapper":
        self.layout.addStretch()
        return self

    def build_layout(self) -> QBoxLayout:
        return self.layout

    def content_margins(self, left: int = 0, top: int = 0, right: int = 0, bottom: int = 0) -> "ViewWrapper":
        self.layout.setContentsMargins(left, top, right, bottom)
        return self
