from PyQt6.QtCore import QSize, Qt
from PyQt6.QtGui import QIcon, QPixmap, QPainter, QColor
from PyQt6.QtSvg import QSvgRenderer

from utils import resource_path


def svg_icon(path: str) -> QIcon:
    return QIcon(resource_path(path))

def svg_icon_colored(path: str, size: int, color: str) -> QIcon:
    renderer = QSvgRenderer(resource_path(path))
    pixmap = QPixmap(size, size)
    pixmap.fill(Qt.GlobalColor.transparent)
    painter = QPainter(pixmap)
    painter.setCompositionMode(QPainter.CompositionMode.CompositionMode_Source)
    renderer.render(painter)
    painter.setCompositionMode(QPainter.CompositionMode.CompositionMode_SourceIn)
    painter.fillRect(pixmap.rect(), QColor(color))
    painter.end()
    return QIcon(pixmap)

class IconHelper:
    @staticmethod
    def new(on_icon: str, off_icon: str) -> QIcon:
        icon = QIcon()
        icon.addFile(resource_path(off_icon), QSize(), QIcon.Mode.Normal, QIcon.State.Off)
        icon.addFile(resource_path(on_icon), QSize(), QIcon.Mode.Normal, QIcon.State.On)
        return icon
