from typing import Callable, Type, Generic, Any, TypeVar

from pydantic import BaseModel

from core.config.ConfigLoader import ConfigLoader

T = TypeVar("T", bound=BaseModel)

class ConfigLoaderWrapper(Generic[T]):
    def __init__(self, path: str, model: Type[T], migrateFunc: Callable[[Any], T] = None):
        self.loader = ConfigLoader(path, model, migrateFunc)
        self.config = self.loader.load()

    def load(self) -> T:
        self.config = self.loader.load()
        return self.config

    def save(self) -> None:
        self.loader.save(self.config)
