import os
from enum import Enum

import pygame

from core.settings_manager import SettingsManager
from utils import resource_path


class SoundManager:
    __instance = None

    def __init__(self):
        pygame.mixer.init()
        self.__is_enabled = True

    @staticmethod
    def instance():
        if SoundManager.__instance is None:
            SoundManager.__instance = SoundManager()
            pygame.mixer.music.set_volume(SettingsManager.instance().app_settings.sound_volume)
        return SoundManager.__instance

    @property
    def is_enabled(self):
        return self.__is_enabled

    def set_is_enabled(self, is_enabled):
        self.__is_enabled = is_enabled

    class Sound(Enum):
        EAGLE = "1eagle.wav"

    def set_volume(self, volume: float, with_save: bool = True):
        pygame.mixer.music.set_volume(volume)
        SettingsManager.instance().app_settings.setVolume(volume)
        if with_save:
            SettingsManager.instance().save_settings()

    def play(self, sound: Sound) -> None:
        if not self.__is_enabled:
            return
        try:
            sound_path = resource_path(os.path.join("assets", "sounds", sound.value))
            pygame.mixer.music.load(sound_path)
            pygame.mixer.music.play()
        except Exception as e:
            print(f"Failed to play sound: {e}")
