import gettext
from pathlib import Path

from utils import resource_path


class I18n:
    def __init__(self, domain="app", locales_dir="assets/locales", locale="en_US"):
        self.domain = domain
        self.locales_dir = locales_dir
        self._current = locale
        # self.qt_translator = None
        self._load(locale)

    def _load(self, lang):
        print(f"[I18n] Start loading {lang}")
        mo = Path(resource_path(f"{self.locales_dir}/{lang}/{self.domain}.mo"))
        if not mo.exists():
            print(f"[i18n] not found: {mo}")
        try:
            with mo.open(mode='rb') as f:
                self._t = gettext.GNUTranslations(f)
            print(f"[I18n] End loading {lang}")
        except Exception as e:
            print("[i18n] load error:", e)
            self._t = gettext.NullTranslations()

        # if self.qt_translator:
        #     QApplication.instance().removeTranslator(self.qt_translator)
        #
        # self.qt_translator = QTranslator()
        # qtbase_path = QLibraryInfo.path(QLibraryInfo.LibraryPath.TranslationsPath)
        # self.qt_translator.load(f"qtbase_{lang}", qtbase_path)
        # QApplication.instance().installTranslator(self.qt_translator)

    def set_language(self, lang):
        self._current = lang
        self._load(lang)

    # короткие алиасы
    def _(self, key):  # обычные строки
        return self._t.gettext(key)

    def n_(self, key, n):  # plural по правилам языка
        return self._t.ngettext(f"{key}.one", f"{key}.many", n)


i18n: I18n = I18n()
_ = i18n._  # use: _("app.menu.file.open")
_n = i18n.n_  # use: _n("files.one", "files.many", n)