from PyQt6.QtCore import Qt
from PyQt6.QtGui import QColor
from PyQt6.QtWebEngineCore import QWebEnginePage
from PyQt6.QtWebEngineWidgets import QWebEngineView

from ui.components.DefaultMenu import DefaultMenu
from ui.components.webview import DebugWebEnginePage


class ChatWebEngineView(QWebEngineView):
    def __init__(self, parent=None):
        super(ChatWebEngineView, self).__init__(parent)
        # self.setUpdatesEnabled(True)
        # self.setAttribute(Qt.WA_StyledBackground, True)
        debug_page = DebugWebEnginePage(self)
        debug_page.setBackgroundColor(QColor('#1A1A1A'))
        self.setContextMenuPolicy(Qt.ContextMenuPolicy.CustomContextMenu)
        self.customContextMenuRequested.connect(self.show_copy_menu)
        self.setPage(debug_page)

    def show_copy_menu(self, pos):
        menu = DefaultMenu(self)

        copy_action = self.pageAction(QWebEnginePage.WebAction.Copy)
        copy_action.setEnabled(self.hasSelection())
        menu.addAction(copy_action)

        menu.exec(self.mapToGlobal(pos))