// Chat Interface JavaScript - EXTRACTED FROM chat_interface.html
// All comments are in ENGLISH as required by project rules.
let backend = null;
function initChannel() {
    if (typeof qt === 'undefined' || typeof qt.webChannelTransport === 'undefined') {
        setTimeout(initChannel, 100);
        return;
    }
    new QWebChannel(qt.webChannelTransport, function(channel) {
        backend = channel.objects.backend;
    });
    applyZoom();
}
window.onload = function () { initChannel(); };
function triggerAction(action, params = {}) {
    if (backend) backend.handleAction(action, params);
}
function getZoomLevel() { return window.devicePixelRatio || 1; }
function applyZoom() {};
window.onresize = applyZoom;
function getGryphonSVG() {
    return `<svg class="gryphon-svg" width="36" height="36" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_370_3203)">
<circle cx="20" cy="20" r="20" fill="white"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M28.3904 40.0452C27.0106 38.3204 25.3487 33.5363 25.8032 27.627C26.3207 20.9005 32.0185 15.2091 34.5994 14.6917C35.3804 14.5351 35.8782 14.5206 36.1928 14.5767C36.4655 14.6252 36.5503 14.5555 36.4778 14.2881C36.112 12.9399 35.1058 10.5483 32.5279 10.1806C29.9407 9.81152 27.3555 10.5521 27.3555 10.5521C27.3555 10.5521 25.8032 9 23.2161 9C19.3051 9 15.7451 11.8452 12.6299 14.3349C10.6945 15.8817 8.93081 17.2913 7.36125 17.7962C5.38687 18.4313 4.22559 16.9325 3.77358 16.1563C3.6881 16.0096 3.45669 16.023 3.40987 16.1863C3.13924 17.1301 2.64334 19.3225 3.35277 20.8084C4.21677 22.6181 5.90004 22.8769 7.25636 23.0855C8.22682 23.2347 9.02989 23.3581 9.2457 24.0056C10.2562 27.0371 -1 33.4741 -1 33.4741C-1 33.4741 2.41288 40.0452 11.6336 43.2275C19.95 46.0978 28.3904 40.0452 28.3904 40.0452ZM18.5935 15.228C19.7152 13.9133 20.8514 13.1121 23.1231 13.2535C24.1044 13.3147 21.82 16.8091 18.7496 15.8268C18.4945 15.7452 18.4197 15.4318 18.5935 15.228Z" fill="#3D3D3D"/>
</g>
<defs>
<clipPath id="clip0_370_3203">
<rect width="40" height="40" rx="20" fill="white"/>
</clipPath>
</defs>
</svg>`;
}
function getAvatarForRole(role) {
    if (role === 'user') return '<div class="avatar user" title="You">U</div>';
    if (role === 'bot' || role === 'assistant' || role === 'tool')
        return `<div class="avatar bot" title="Gryphon">${getGryphonSVG()}</div>`;
    return '';
}
function ensureThinkingIndicatorAtBottom() {
    var chat = document.getElementById('chat');
    var loader = chat.querySelector('.message-row.bot.has-loader');
    if (loader && loader !== chat.lastElementChild) {
        chat.appendChild(loader);
        chat.scrollTop = chat.scrollHeight;
    }
}
function appendMessage(role, content, message_type, options) {
    var chat = document.getElementById('chat');
    var attachments = (options && Array.isArray(options.attachments)) ? options.attachments : null;

    if (message_type === 'function_call_output') {
        role = 'sys';
    }

    if (["user", "bot", "assistant", "tool"].includes(role)) {
        var row = document.createElement('div');
        row.className = 'message-row ' + role;
        var showAvatar = true;
        var lastRow = chat.lastElementChild;
        if (lastRow && lastRow.classList.contains('message-row')) {
            if (lastRow.classList.contains(role)) {
                showAvatar = false;
            }
        }
        row.setAttribute('data-has-loader', 'false');
        row.classList.remove('has-loader');
        var avatarHTML = showAvatar ? getAvatarForRole(role) : '';
        var avatarElem = document.createElement('div');
        avatarElem.innerHTML = avatarHTML;
        var bubble = document.createElement('div');
        bubble.className = 'chat-bubble';

        if (attachments && attachments.length > 0) {
            var gallery = document.createElement('div');
            gallery.className = 'msg-attachments-gallery';
            for (let img64 of attachments) {
                var img = document.createElement('img');
                img.src = 'data:image/png;base64,' + img64;
                img.className = 'msg-attachment-img';
                gallery.appendChild(img);
            }
            bubble.appendChild(gallery);
            bubble.appendChild(document.createElement('br'));
        }

        bubble.innerHTML += content;
        if (role === 'user') { row.appendChild(bubble); row.appendChild(avatarElem); }
        else { row.appendChild(avatarElem); row.appendChild(bubble); }
        chat.appendChild(row);
    } else {
        var messageDiv = document.createElement('div');
        var msgClass = 'message ' + role;
        if (role === 'info') { msgClass += ' has-icon'; }
        messageDiv.className = msgClass;
        messageDiv.innerHTML = content;
        chat.appendChild(messageDiv);
    }
    ensureThinkingIndicatorAtBottom();
    chat.scrollTop = chat.scrollHeight;
}
function removeMessage(role) {
    var chat = document.getElementById('chat');
    if (["user", "bot", "assistant", "tool"].includes(role)) {
        var rows = chat.getElementsByClassName('message-row ' + role);
        if (rows.length > 0) {
            chat.removeChild(rows[rows.length - 1]);
            ensureThinkingIndicatorAtBottom();
            return;
        }
    }
    var messages = chat.getElementsByClassName('message ' + role);
    if (messages.length > 0) {
        var last = messages[messages.length - 1];
        last.classList.add('fading');
        setTimeout(function() {
            if (last && last.parentNode) {
                last.parentNode.removeChild(last);
                ensureThinkingIndicatorAtBottom();
            }
        }, 260);
    }
}
function clearChatDisplay() {
    var chat = document.getElementById('chat');
    chat.innerHTML = '';
}
function showThinkingIndicator(content) {
    var chat = document.getElementById('chat');
    var existingLoader = chat.querySelector('.message-row.bot.has-loader');
    if (existingLoader) {
        chat.removeChild(existingLoader);
    }
    var row = document.createElement('div');
    row.className = 'message-row bot has-loader';
    row.setAttribute('data-has-loader', 'true');
    var avatarWrapper = document.createElement('div');
    avatarWrapper.innerHTML = getAvatarForRole('bot');
    var loaderWrapper = document.createElement('div');
    loaderWrapper.className = 'thinking-indicator';
    loaderWrapper.innerHTML = '<span class="dot-loader"></span>';
    row.appendChild(avatarWrapper);
    row.appendChild(loaderWrapper);
    chat.appendChild(row);
    chat.scrollTop = chat.scrollHeight;
}
function hideThinkingIndicator() {
    var chat = document.getElementById('chat');
    var rows = chat.querySelectorAll('.message-row.bot.has-loader');
    if (rows.length > 0) {
        var lastRow = rows[rows.length - 1];
        lastRow.classList.add('fading');
        setTimeout(function() {
            if (lastRow && lastRow.parentNode) {
                lastRow.parentNode.removeChild(lastRow);
            }
        }, 260);
    }
}
